/**
 * Atualiza dinamicamente meta tags com base nas rotas.
 * @param {Object} meta - Objeto contendo título e meta tags.
 */
function updateMetaTags(meta) {

    let defaultMeta = {
        title: 'AkkiPerto',
        description: 'Descubra a comodidade de ter tudo o que você precisa ao alcance dos seus dedos com o Akki Perto! Aqui você encontra vagas, eventos, produtos, profissionais e muito mais!',
        image: '/logo.png',
    };

    const metaTags = [
        { name: 'description', content: meta.description || defaultMeta.description },
        { property: 'og:title', content: meta.title || defaultMeta.title },
        { property: 'og:description', content: meta.description || defaultMeta.description },
        { property: 'og:image', content: meta.image || defaultMeta.image },
        { property: 'og:url', content: window.location.href },
        { name: 'twitter:card', content: 'summary_large_image' },
        { name: 'twitter:title', content: meta.title || defaultMeta.title },
        { name: 'twitter:description', content: meta.description || defaultMeta.description },
    ];

    // Atualiza ou cria cada meta tag dinamicamente
    metaTags.forEach(({ name, property, content }) => {
        if (!content) return; // Ignora se o conteúdo for indefinido ou nulo

        let metaTag = document.querySelector(`meta[${name ? 'name' : 'property'}="${name || property}"]`);
        if (!metaTag) {
            metaTag = document.createElement('meta');
            if (name) metaTag.setAttribute('name', name);
            if (property) metaTag.setAttribute('property', property);
            document.head.appendChild(metaTag);
        }
        metaTag.setAttribute('content', content);
    });

    // Atualiza o título da página
    if (meta.title) {
        document.title = meta.title;
    }
}

function removerHTMLDescricoes(descricao) {
    return descricao.replace(/<[^>]*>?/gm, '');
}

export { updateMetaTags, removerHTMLDescricoes };