export async function sendLogToServer(level, dataArray, callerInfo) {
    try {
        // Incluir `callerInfo` nos dados que vão ao backend
        dataArray = dataArray.filter((item) => item && item !== '');

        const payload = {
            data: JSON.stringify(dataArray),
            type: level,
            version: useCookie('vApp').value || 'n/a',
            caller: callerInfo || '' // se não tiver info, manda string vazia
        };

        await $api('/options/logger-front-end', {
            method: 'POST',
            body: payload
        });
    } catch (error) {
        // Evitar loop infinito de logs
        // Mas se quiser, pode usar "original console.warn" aqui também
        //console.warn('Falha ao enviar log para o servidor:', error);
    }
}

// loggerBuffer.js
let logsBuffer = [];
let sending = false;

// Função chamada pelos console.* patchs
export function bufferLog(level, dataArray, callerInfo) {
    if (!dataArray.length || dataArray == '' || dataArray == null || dataArray == undefined ||
        dataArray == '{}' || dataArray == '[]') return;
    logsBuffer.push({
        level,
        data: dataArray,
        caller: callerInfo,
        timestamp: Date.now(),
        version: useCookie('vApp').value || 'n/a'
    });
}

// Função para enviar logs acumulados
async function flushLogs() {
    if (sending || logsBuffer.length === 0) return;

    sending = true;
    const batch = logsBuffer.splice(0, logsBuffer.length); // pega todos e limpa
    try {
        await $api('/options/logger-front-end/bulk', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(batch)
        });
    } catch (err) {
        console.error('Erro ao enviar logs em lote', err);
        // Se quiser, re-insere o batch no buffer. Ou descarta, dependendo da lógica desejada
        logsBuffer = batch.concat(logsBuffer);
    }
    sending = false;
}

// Agenda flush a cada 10 segundos
setInterval(flushLogs, 10000);
