import { deepMerge } from '@antfu/utils'
import { useI18n } from 'vue-i18n'
import { createVuetify } from 'vuetify'
import { VBtn } from 'vuetify/components/VBtn'
import { createVueI18nAdapter } from 'vuetify/locale/adapters/vue-i18n'
import defaults from './defaults'
import { icons } from './icons'
import { staticPrimaryColor, themes } from './theme'
import { getI18n } from '@/plugins/i18n/index'
import * as VSkeletonLoader from 'vuetify/labs/VSkeletonLoader'
import * as VStepper from 'vuetify/labs/VStepper'
import * as VDatePicker from 'vuetify/labs/VDatePicker'
import { VDataTableServer } from 'vuetify/labs/VDataTable'
import { VueMaskDirective } from 'v-mask'
import { Money3Component, Money3Directive  } from 'v-money3'

// Styles
import { cookieRef } from '@/@layouts/stores/config'
import '@core/scss/template/libs/vuetify/index.scss'
import 'vuetify/styles'

export default function (app) {
  const cookieThemeValues = {
    defaultTheme: resolveVuetifyTheme(),
    themes: {
      light: {
        colors: {
          primary: cookieRef('lightThemePrimaryColor', staticPrimaryColor).value,
        },
      },
      dark: {
        colors: {
          primary: cookieRef('darkThemePrimaryColor', staticPrimaryColor).value,
        },
      },
    },
  }

  const optionTheme = deepMerge({ themes }, cookieThemeValues)

  const vuetify = createVuetify({
    aliases: {
      IconBtn: VBtn,
    },
    defaults,
    icons,
    theme: optionTheme,
    locale: {
      adapter: createVueI18nAdapter({ i18n: getI18n(), useI18n }),
    },
    components: { ...VSkeletonLoader, ...VStepper, ...VDatePicker, VDataTableServer, money3: Money3Component },
    directives: { ...VueMaskDirective, money3: Money3Directive },
  })

  app.use(vuetify)
}
