// 👉 Redirects
export const redirects = [
  // ℹ️ We are redirecting to different pages based on role.
  // NOTE: Role is just for UI purposes. ACL is based on abilities.
];
export const routes = [
  {
    path: "/",
    name: "index",
    component: () => import("@/pages/home.vue"),
    meta: { public: true },
  },
  //Eventos
  {
    path: "/eventos/checkout/:data",
    name: "checkout-events",
    component: () => import("@/pages/apps/eventos/checkout-ticket.vue"),
    meta: { public: true, title: 'Finalizar Pagamento - AkkiPerto' },
  },
  {
    path: '/eventos',
    name: 'app-events-list',
    component: () => import('@/pages/apps/eventos/eventos.vue'),
    meta: { 
      public: true,
      title: 'Eventos - AkkiPerto',
      description: 'Confira os eventos disponíveis no AkkiPerto. Aqui você encontra informações sobre eventos, shows, festas e muito mais!'
     },
  },
  {
    path: '/eventos/:slug',
    name: 'app-event-detail',
    component: () => import('@/pages/apps/eventos/evento.vue'),
    meta: { public: true },
  },
  {
    path: "/meus-ingressos",
    name: "my-tickets",
    component: () => import("@/pages/apps/eventos/meus-ingressos.vue"),
    meta: { public: true, title: 'Meus Ingressos' },
  },
  {
    path: "/vagas",
    name: "Vagas",
    component: () => import("@/pages/vagas/vagas.vue"),
    meta: {
      public: true, title: 'Vagas de Emprego - Akki Perto',
      description: 'Encontre vagas de emprego em sua região. Cadastre seu currículo e candidate-se às vagas disponíveis.',
    },
  },
  {
    path: "/vagas/:slug",
    name: "DetalhesVaga",
    component: () => import("@/pages/vagas/detalhesVaga.vue"),
    meta: { public: true },
  },
  {
    path: "/vagas/candidatar/:id",
    name: "candidaturaVaga",
    component: () => import("@/pages/vagas/candidaturaVaga.vue"),
    meta: { public: true },
  },
  {
    path: "/meu-curriculo",
    name: "meuCurriculo",
    component: () => import("@/pages/vagas/curriculo.vue"),
    meta: { public: true, title: 'Meu Currículo' },
  },
  {
    path: "/minhas-candidaturas",
    name: "minhasCandidaturas",
    component: () => import("@/pages/vagas/minhas-candidaturas.vue"),
    meta: { public: true, title: 'Minhas Candidaturas' },
  },
  //Nova Senha
  {
    path: "/redefinirSenha",
    name: "redefinirSenha",
    component: () => import("@/pages/novaSenha.vue"),
    meta: {
      layout: "blank",
      unauthenticatedOnly: true,
      title: 'Redefinir Senha - AkkiPerto',
    },
  },
  //Editar Perfil
  {
    path: "/editar-perfil/:tab?",
    name: "editarPerfil",
    component: () => import("@global/components/pages/user/profile/[tab].vue"),
    meta: { public: true, title: 'Editar Perfil - AkkiPerto' },
  },
  //Construcao
  {
    path: "/construcao",
    name: "construcao",
    component: () => import("@global/components/pages/construcao.vue"),
    meta: { public: true },
  },
  //Redirect/gestor
  {
    path: "/redirect/gestor",
    name: "redirectGestor",
    component: () => import("@/pages/redirect-gestor.vue"),
    meta: {
      layout: "blank",
      action: "read",
      subject: "all",
      title: 'Redirecionando - AkkiPerto',
    },
  },
  //Termos de uso
  {
    path: "/termos-de-uso",
    name: "termosDeUso",
    component: () => import("@/pages/termos-uso.vue"),
    meta: {
      public: true,
      title: 'Termos de Uso - AkkiPerto',
      description: 'Leia os termos de uso do AkkiPerto. Aqui você encontra informações sobre o uso do site e suas funcionalidades.'
    },
  },
  {
    path: "/politica-de-privacidade",
    name: "politicaPrivacidade",
    component: () => import("@/pages/politica-privacidade.vue"),
    meta: {
      public: true,
      title: 'Política de Privacidade - AkkiPerto',
      description: 'Leia a política de privacidade do AkkiPerto. Aqui você encontra informações sobre a privacidade dos seus dados e informações.'
    },
  },
  {
    path: "/termos-politicas-vagas",
    name: "termosPoliticasVagas",
    component: () => import("@/pages/termos-vagas.vue"),
    meta: {
      public: true,
      title: 'Termos e Políticas de Vagas - AkkiPerto',
      description: 'Leia os termos e políticas de vagas do AkkiPerto. Aqui você encontra informações sobre a utilização do serviço de vagas.'
    },
  },
  {
    path: "/termos-politicas-eventos",
    name: "termosPoliticasEventos",
    component: () => import("@/pages/termos-eventos.vue"),
    meta: {
      public: true,
      title: 'Termos e Políticas de Eventos - AkkiPerto',
      description: 'Leia os termos e políticas de eventos do AkkiPerto. Aqui você encontra informações sobre a utilização do serviço de eventos.'
    },
  },
  //Login
  {
    path: "/login",
    name: "login",
    component: () => import("@/pages/login.vue"),
    meta: {
      layout: "blank",
      unauthenticatedOnly: true,
      public: true
    },
  },
  //Registro
  {
    path: "/register",
    name: "register",
    component: () => import("@/pages/register.vue"),
    meta: {
      layout: "blank",
      unauthenticatedOnly: true,
      public: true
    },
  },
  //Unsub email
  {
    path: '/desinscrever-email-vagas',
    name: 'desinscrever-email',
    component: () => import('@/pages/unsub-emails-vagas.vue'),
    meta: {
      layout: 'blank',
      public: true,
    },
  }
];
