if (import.meta.env.PROD) {
  // Se quiser importar de forma dinâmica/assíncrona:
  import('./utils/patchConsole.js');
}

import App from '@/App.vue'
import { registerPlugins } from '@core/utils/plugins'
import { createApp } from 'vue'
import FlatPickr from 'vue-flatpickr-component'
import 'flatpickr/dist/flatpickr.css'
import VueTheMask from 'vue-the-mask'
import { registerSW } from 'virtual:pwa-register';
import VueGtag from "vue-gtag-next";
import { createGtm } from '@gtm-support/vue-gtm';
import { PerfectScrollbar } from 'vue3-perfect-scrollbar'
import vue3GoogleLogin from 'vue3-google-login'
import VueDatePicker from '@vuepic/vue-datepicker';
import '@vuepic/vue-datepicker/dist/main.css'

// Styles
import '@core/scss/template/index.scss'
import '@styles/styles.scss'

// Create vue app
const app = createApp(App)

//Register FlatPickr
app.component('FlatPickr', FlatPickr)
app.component('PerfectScrollbar', PerfectScrollbar)
app.component('VueDatePicker', VueDatePicker);

// Register plugins
registerPlugins(app)

//Mask
app.use(VueTheMask)

//GTAG
app.use(VueGtag, {
  property: {
    id: 'G-MX34N1M76K'
  }
});

//GTM
app.use(createGtm({
  id: 'GTM-TB8KQFP7',
  defer: true,
  enabled: true,
  loadScript: true,
}));

//Google Login
app.use(vue3GoogleLogin, {
  clientId: '467690812188-mkpj7tmnnvcgq8hjgj137nq7es20gjoi.apps.googleusercontent.com',
})

// Mount vue app
app.mount('#app')

const updateSW = registerSW({
  onNeedRefresh() { },
  onOfflineReady() { },
});

const isInstagramBrowser = /Instagram/i.test(navigator.userAgent);
const isFacebookBrowser = /FBAV/i.test(navigator.userAgent);

if ('serviceWorker' in navigator && !isInstagramBrowser && !isFacebookBrowser) {
  navigator.serviceWorker
    .register('/firebase-messaging-sw.js') // Certifique-se de que o caminho está correto
    .then((registration) => {
      //console.log('Service Worker registrado com sucesso:', registration);
    })
    .catch((error) => {
      //console.error('Erro ao registrar o Service Worker:', error);
    });
}
