export enum EventStatusEnum {
  Approved = 1,
  Inactive = 2,
  UnderAnalysis = 3,
  RejectedByAdmin = 4,
  UnderReview = 5,
}

export const eventStatusPipe = (status: EventStatusEnum): String => {
  switch (status) {
    case EventStatusEnum.UnderAnalysis:
      "Em análise"
      break;
    case EventStatusEnum.RejectedByAdmin:
      "Reprovado pela administração"
      break;
    case EventStatusEnum.UnderReview:
      "Em revisão"
      break;
    case EventStatusEnum.Approved:
      "Ativo"
      break;
    case EventStatusEnum.Inactive:
      "Inativo"
      break;
    default:
      "-"
      break;
  }
}
