/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.newhope;

import org.bouncycastle.pqc.crypto.newhope.ChaCha20;
import org.bouncycastle.util.Arrays;

class ErrorCorrection {
    ErrorCorrection() {
    }

    static int abs(int v) {
        int mask = v >> 31;
        return (v ^ mask) - mask;
    }

    static int f(int[] v, int off0, int off1, int x) {
        int b = x * 2730;
        int t2 = b >> 25;
        b = x - t2 * 12289;
        b = 12288 - b;
        int r = (t2 -= (b >>= 31)) & 1;
        int xit = t2 >> 1;
        v[off0] = xit + r;
        r = --t2 & 1;
        v[off1] = (t2 >> 1) + r;
        return ErrorCorrection.abs(x - v[off0] * 2 * 12289);
    }

    static int g(int x) {
        int b = x * 2730;
        int t2 = b >> 27;
        b = x - t2 * 49156;
        b = 49155 - b;
        int c = (t2 -= (b >>= 31)) & 1;
        t2 = (t2 >> 1) + c;
        return ErrorCorrection.abs((t2 *= 98312) - x);
    }

    static void helpRec(short[] c, short[] v, byte[] seed, byte nonce) {
        byte[] iv = new byte[8];
        iv[0] = nonce;
        byte[] rand = new byte[32];
        ChaCha20.process(seed, iv, rand, 0, rand.length);
        int[] vs = new int[8];
        int[] vTmp = new int[4];
        for (int i = 0; i < 256; ++i) {
            int rBit = rand[i >>> 3] >>> (i & 7) & 1;
            int k = ErrorCorrection.f(vs, 0, 4, 8 * v[0 + i] + 4 * rBit);
            k += ErrorCorrection.f(vs, 1, 5, 8 * v[256 + i] + 4 * rBit);
            k += ErrorCorrection.f(vs, 2, 6, 8 * v[512 + i] + 4 * rBit);
            k += ErrorCorrection.f(vs, 3, 7, 8 * v[768 + i] + 4 * rBit);
            k = 24577 - k >> 31;
            vTmp[0] = ~k & vs[0] ^ k & vs[4];
            vTmp[1] = ~k & vs[1] ^ k & vs[5];
            vTmp[2] = ~k & vs[2] ^ k & vs[6];
            vTmp[3] = ~k & vs[3] ^ k & vs[7];
            c[0 + i] = (short)(vTmp[0] - vTmp[3] & 3);
            c[256 + i] = (short)(vTmp[1] - vTmp[3] & 3);
            c[512 + i] = (short)(vTmp[2] - vTmp[3] & 3);
            c[768 + i] = (short)(-k + 2 * vTmp[3] & 3);
        }
    }

    static short LDDecode(int xi0, int xi1, int xi2, int xi3) {
        int t2 = ErrorCorrection.g(xi0);
        t2 += ErrorCorrection.g(xi1);
        t2 += ErrorCorrection.g(xi2);
        t2 += ErrorCorrection.g(xi3);
        return (short)((t2 -= 98312) >>> 31);
    }

    static void rec(byte[] key, short[] v, short[] c) {
        Arrays.fill(key, (byte)0);
        int[] tmp = new int[4];
        for (int i = 0; i < 256; ++i) {
            tmp[0] = 196624 + 8 * v[0 + i] - 12289 * (2 * c[0 + i] + c[768 + i]);
            tmp[1] = 196624 + 8 * v[256 + i] - 12289 * (2 * c[256 + i] + c[768 + i]);
            tmp[2] = 196624 + 8 * v[512 + i] - 12289 * (2 * c[512 + i] + c[768 + i]);
            tmp[3] = 196624 + 8 * v[768 + i] - 12289 * c[768 + i];
            int n = i >>> 3;
            key[n] = (byte)(key[n] | ErrorCorrection.LDDecode(tmp[0], tmp[1], tmp[2], tmp[3]) << (i & 7));
        }
    }
}

