/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TargetInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.jcajce.PKIXCertStoreSelector;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jce.exception.ExtCertPathValidatorException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.CertStatus;
import org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import org.bouncycastle.jce.provider.ReasonsMask;
import org.bouncycastle.x509.PKIXAttrCertChecker;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CertStoreSelector;

class RFC3281CertPathUtilities {
    private static final String TARGET_INFORMATION = Extension.targetInformation.getId();
    private static final String NO_REV_AVAIL = Extension.noRevAvail.getId();
    private static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    private static final String AUTHORITY_INFO_ACCESS = Extension.authorityInfoAccess.getId();

    RFC3281CertPathUtilities() {
    }

    protected static void processAttrCert7(X509AttributeCertificate attrCert, CertPath certPath, CertPath holderCertPath, PKIXExtendedParameters pkixParams, Set attrCertCheckers) throws CertPathValidatorException {
        Set<String> set = attrCert.getCriticalExtensionOIDs();
        if (set.contains(TARGET_INFORMATION)) {
            try {
                TargetInformation.getInstance(CertPathValidatorUtilities.getExtensionValue(attrCert, TARGET_INFORMATION));
            }
            catch (AnnotatedException e) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", e);
            }
            catch (IllegalArgumentException e) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", e);
            }
        }
        set.remove(TARGET_INFORMATION);
        Iterator it = attrCertCheckers.iterator();
        while (it.hasNext()) {
            ((PKIXAttrCertChecker)it.next()).check(attrCert, certPath, holderCertPath, set);
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Attribute certificate contains unsupported critical extensions: " + String.valueOf(set));
        }
    }

    protected static void checkCRLs(X509AttributeCertificate attrCert, PKIXExtendedParameters paramsPKIX, X509Certificate issuerCert, Date validDate, List certPathCerts, JcaJceHelper helper) throws CertPathValidatorException {
        if (paramsPKIX.isRevocationEnabled()) {
            if (attrCert.getExtensionValue(NO_REV_AVAIL) == null) {
                PKIXExtendedParameters paramsPKIXClone;
                CRLDistPoint crldp = null;
                try {
                    crldp = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(attrCert, CRL_DISTRIBUTION_POINTS));
                }
                catch (AnnotatedException e) {
                    throw new CertPathValidatorException("CRL distribution point extension could not be read.", e);
                }
                ArrayList<PKIXCRLStore> crlStores = new ArrayList<PKIXCRLStore>();
                try {
                    crlStores.addAll(CertPathValidatorUtilities.getAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX.getNamedCRLStoreMap()));
                }
                catch (AnnotatedException e) {
                    throw new CertPathValidatorException("No additional CRL locations could be decoded from CRL distribution point extension.", e);
                }
                PKIXExtendedParameters.Builder bldr = new PKIXExtendedParameters.Builder(paramsPKIX);
                Iterator it = crlStores.iterator();
                while (it.hasNext()) {
                    bldr.addCRLStore((PKIXCRLStore)((Object)crlStores));
                }
                paramsPKIX = bldr.build();
                CertStatus certStatus = new CertStatus();
                ReasonsMask reasonsMask = new ReasonsMask();
                AnnotatedException lastException = null;
                boolean validCrlFound = false;
                if (crldp != null) {
                    DistributionPoint[] dps = null;
                    try {
                        dps = crldp.getDistributionPoints();
                    }
                    catch (Exception e) {
                        throw new ExtCertPathValidatorException("Distribution points could not be read.", e);
                    }
                    try {
                        for (int i = 0; i < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                            paramsPKIXClone = (PKIXExtendedParameters)paramsPKIX.clone();
                            RFC3281CertPathUtilities.checkCRL(dps[i], attrCert, paramsPKIXClone, validDate, issuerCert, certStatus, reasonsMask, certPathCerts, helper);
                            validCrlFound = true;
                        }
                    }
                    catch (AnnotatedException e) {
                        lastException = new AnnotatedException("No valid CRL for distribution point found.", e);
                    }
                }
                if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
                    try {
                        ASN1Primitive issuer = null;
                        try {
                            issuer = new ASN1InputStream(((X500Principal)attrCert.getIssuer().getPrincipals()[0]).getEncoded()).readObject();
                        }
                        catch (Exception e) {
                            throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", e);
                        }
                        DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, issuer))), null, null);
                        paramsPKIXClone = (PKIXExtendedParameters)paramsPKIX.clone();
                        RFC3281CertPathUtilities.checkCRL(dp, attrCert, paramsPKIXClone, validDate, issuerCert, certStatus, reasonsMask, certPathCerts, helper);
                        validCrlFound = true;
                    }
                    catch (AnnotatedException e) {
                        lastException = new AnnotatedException("No valid CRL for distribution point found.", e);
                    }
                }
                if (!validCrlFound) {
                    throw new ExtCertPathValidatorException("No valid CRL found.", lastException);
                }
                if (certStatus.getCertStatus() != 11) {
                    String message = "Attribute certificate revocation after " + String.valueOf(certStatus.getRevocationDate());
                    message = message + ", reason: " + RFC3280CertPathUtilities.crlReasons[certStatus.getCertStatus()];
                    throw new CertPathValidatorException(message);
                }
                if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
                    certStatus.setCertStatus(12);
                }
                if (certStatus.getCertStatus() == 12) {
                    throw new CertPathValidatorException("Attribute certificate status could not be determined.");
                }
            } else if (attrCert.getExtensionValue(CRL_DISTRIBUTION_POINTS) != null || attrCert.getExtensionValue(AUTHORITY_INFO_ACCESS) != null) {
                throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
            }
        }
    }

    protected static void additionalChecks(X509AttributeCertificate attrCert, Set prohibitedACAttributes, Set necessaryACAttributes) throws CertPathValidatorException {
        for (String oid : prohibitedACAttributes) {
            if (attrCert.getAttributes(oid) == null) continue;
            throw new CertPathValidatorException("Attribute certificate contains prohibited attribute: " + oid + ".");
        }
        for (String oid : necessaryACAttributes) {
            if (attrCert.getAttributes(oid) != null) continue;
            throw new CertPathValidatorException("Attribute certificate does not contain necessary attribute: " + oid + ".");
        }
    }

    protected static void processAttrCert5(X509AttributeCertificate attrCert, PKIXExtendedParameters pkixParams) throws CertPathValidatorException {
        try {
            attrCert.checkValidity(CertPathValidatorUtilities.getValidDate(pkixParams));
        }
        catch (CertificateExpiredException e) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", e);
        }
    }

    protected static void processAttrCert4(X509Certificate acIssuerCert, Set trustedACIssuers) throws CertPathValidatorException {
        Set set = trustedACIssuers;
        boolean trusted = false;
        for (TrustAnchor anchor : set) {
            if (!acIssuerCert.getSubjectX500Principal().getName("RFC2253").equals(anchor.getCAName()) && !acIssuerCert.equals(anchor.getTrustedCert())) continue;
            trusted = true;
        }
        if (!trusted) {
            throw new CertPathValidatorException("Attribute certificate issuer is not directly trusted.");
        }
    }

    protected static void processAttrCert3(X509Certificate acIssuerCert, PKIXExtendedParameters pkixParams) throws CertPathValidatorException {
        if (acIssuerCert.getKeyUsage() != null && !acIssuerCert.getKeyUsage()[0] && !acIssuerCert.getKeyUsage()[1]) {
            throw new CertPathValidatorException("Attribute certificate issuer public key cannot be used to validate digital signatures.");
        }
        if (acIssuerCert.getBasicConstraints() != -1) {
            throw new CertPathValidatorException("Attribute certificate issuer is also a public key certificate issuer.");
        }
    }

    protected static CertPathValidatorResult processAttrCert2(CertPath certPath, PKIXExtendedParameters pkixParams) throws CertPathValidatorException {
        CertPathValidator validator = null;
        try {
            validator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (NoSuchProviderException e) {
            throw new ExtCertPathValidatorException("Support class could not be created.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExtCertPathValidatorException("Support class could not be created.", e);
        }
        try {
            return validator.validate(certPath, pkixParams);
        }
        catch (CertPathValidatorException e) {
            throw new ExtCertPathValidatorException("Certification path for issuer certificate of attribute certificate could not be validated.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected static CertPath processAttrCert1(X509AttributeCertificate attrCert, PKIXExtendedParameters pkixParams) throws CertPathValidatorException {
        int i;
        Principal[] principals;
        X509CertSelector selector;
        CertPathBuilderResult result = null;
        HashSet holderPKCs = new HashSet();
        if (attrCert.getHolder().getIssuer() != null) {
            selector = new X509CertSelector();
            selector.setSerialNumber(attrCert.getHolder().getSerialNumber());
            principals = attrCert.getHolder().getIssuer();
            for (i = 0; i < principals.length; ++i) {
                try {
                    if (principals[i] instanceof X500Principal) {
                        selector.setIssuer(((X500Principal)principals[i]).getEncoded());
                    }
                    holderPKCs.addAll(CertPathValidatorUtilities.findCertificates(new PKIXCertStoreSelector.Builder(selector).build(), pkixParams.getCertStores()));
                    continue;
                }
                catch (AnnotatedException e) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", e);
                }
                catch (IOException e) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", e);
                }
            }
            if (holderPKCs.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in base certificate ID for attribute certificate cannot be found.");
            }
        }
        if (attrCert.getHolder().getEntityNames() != null) {
            selector = new X509CertStoreSelector();
            principals = attrCert.getHolder().getEntityNames();
            for (i = 0; i < principals.length; ++i) {
                try {
                    if (principals[i] instanceof X500Principal) {
                        selector.setIssuer(((X500Principal)principals[i]).getEncoded());
                    }
                    holderPKCs.addAll(CertPathValidatorUtilities.findCertificates(new PKIXCertStoreSelector.Builder(selector).build(), pkixParams.getCertStores()));
                    continue;
                }
                catch (AnnotatedException e) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", e);
                }
                catch (IOException e) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", e);
                }
            }
            if (holderPKCs.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in entity name for attribute certificate cannot be found.");
            }
        }
        PKIXExtendedParameters.Builder paramsBldr = new PKIXExtendedParameters.Builder(pkixParams);
        ExtCertPathValidatorException lastException = null;
        Iterator it = holderPKCs.iterator();
        while (it.hasNext()) {
            X509CertStoreSelector selector2 = new X509CertStoreSelector();
            selector2.setCertificate((X509Certificate)it.next());
            paramsBldr.setTargetConstraints(new PKIXCertStoreSelector.Builder(selector2).build());
            CertPathBuilder builder = null;
            try {
                builder = CertPathBuilder.getInstance("PKIX", "BC");
            }
            catch (NoSuchProviderException e) {
                throw new ExtCertPathValidatorException("Support class could not be created.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ExtCertPathValidatorException("Support class could not be created.", e);
            }
            try {
                result = builder.build(new PKIXExtendedBuilderParameters.Builder(paramsBldr.build()).build());
            }
            catch (CertPathBuilderException e) {
                lastException = new ExtCertPathValidatorException("Certification path for public key certificate of attribute certificate could not be build.", e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return result.getCertPath();
    }

    private static void checkCRL(DistributionPoint dp, X509AttributeCertificate attrCert, PKIXExtendedParameters paramsPKIX, Date validDate, X509Certificate issuerCert, CertStatus certStatus, ReasonsMask reasonMask, List certPathCerts, JcaJceHelper helper) throws AnnotatedException {
        if (attrCert.getExtensionValue(X509Extensions.NoRevAvail.getId()) != null) {
            return;
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set crls = CertPathValidatorUtilities.getCompleteCRLs(dp, attrCert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        AnnotatedException lastException = null;
        Iterator crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                ReasonsMask interimReasonsMask = RFC3280CertPathUtilities.processCRLD(crl, dp);
                if (!interimReasonsMask.hasNewReasons(reasonMask)) continue;
                Set keys = RFC3280CertPathUtilities.processCRLF(crl, attrCert, null, null, paramsPKIX, certPathCerts, helper);
                PublicKey key = RFC3280CertPathUtilities.processCRLG(crl, keys);
                X509CRL deltaCRL = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set deltaCRLs = CertPathValidatorUtilities.getDeltaCRLs(currentDate, crl, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores());
                    deltaCRL = RFC3280CertPathUtilities.processCRLH(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && attrCert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3280CertPathUtilities.processCRLB1(dp, attrCert, crl);
                RFC3280CertPathUtilities.processCRLB2(dp, attrCert, crl);
                RFC3280CertPathUtilities.processCRLC(deltaCRL, crl, paramsPKIX);
                RFC3280CertPathUtilities.processCRLI(validDate, deltaCRL, attrCert, certStatus, paramsPKIX);
                RFC3280CertPathUtilities.processCRLJ(validDate, crl, attrCert, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(interimReasonsMask);
                validCrlFound = true;
            }
            catch (AnnotatedException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }
}

