/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.bc;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.bc.EnvelopedDataHelper;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.util.CipherFactory;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputAEADEncryptor;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.Integers;

public class BcCMSContentEncryptorBuilder {
    private static Map keySizes = new HashMap();
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper();
    private SecureRandom random;

    private static int getKeySize(ASN1ObjectIdentifier oid) {
        Integer size = (Integer)keySizes.get(oid);
        if (size != null) {
            return size;
        }
        return -1;
    }

    public BcCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, BcCMSContentEncryptorBuilder.getKeySize(encryptionOID));
    }

    public BcCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public BcCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        if (this.helper.isAuthEnveloped(this.encryptionOID)) {
            return new CMSAuthOutputEncryptor(this, this.encryptionOID, this.keySize, this.random);
        }
        return new CMSOutputEncryptor(this, this.encryptionOID, this.keySize, this.random);
    }

    static {
        keySizes.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(256));
        keySizes.put(CMSAlgorithm.AES128_GCM, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.AES192_GCM, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.AES256_GCM, Integers.valueOf(256));
        keySizes.put(CMSAlgorithm.CAMELLIA128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.CAMELLIA192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.CAMELLIA256_CBC, Integers.valueOf(256));
    }

    private class CMSAuthOutputEncryptor
    extends CMSOutputEncryptor
    implements OutputAEADEncryptor {
        private AEADBlockCipher aeadCipher = this.getCipher();

        CMSAuthOutputEncryptor(BcCMSContentEncryptorBuilder bcCMSContentEncryptorBuilder, ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            super(bcCMSContentEncryptorBuilder, encryptionOID, keySize, random);
        }

        private AEADBlockCipher getCipher() {
            if (!(this.cipher instanceof AEADBlockCipher)) {
                throw new IllegalArgumentException("Unable to create Authenticated Output Encryptor without Authenticaed Data cipher!");
            }
            return (AEADBlockCipher)this.cipher;
        }

        @Override
        public OutputStream getAADStream() {
            return new AADStream(this.aeadCipher);
        }

        @Override
        public byte[] getMAC() {
            return this.aeadCipher.getMac();
        }
    }

    private class CMSOutputEncryptor
    implements OutputEncryptor {
        private KeyParameter encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        protected Object cipher;

        CMSOutputEncryptor(BcCMSContentEncryptorBuilder bcCMSContentEncryptorBuilder, ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            if (random == null) {
                random = new SecureRandom();
            }
            CipherKeyGenerator keyGen = bcCMSContentEncryptorBuilder.helper.createKeyGenerator(encryptionOID, random);
            this.encKey = new KeyParameter(keyGen.generateKey());
            this.algorithmIdentifier = bcCMSContentEncryptorBuilder.helper.generateEncryptionAlgID(encryptionOID, this.encKey, random);
            this.cipher = EnvelopedDataHelper.createContentCipher(true, this.encKey, this.algorithmIdentifier);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            return CipherFactory.createOutputStream(dOut, this.cipher);
        }

        @Override
        public GenericKey getKey() {
            return new GenericKey(this.algorithmIdentifier, this.encKey.getKey());
        }
    }

    private static class AADStream
    extends OutputStream {
        private AEADBlockCipher cipher;

        public AADStream(AEADBlockCipher cipher) {
            this.cipher = cipher;
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.cipher.processAADBytes(buf, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.cipher.processAADByte((byte)b);
        }
    }
}

