/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Joiner;
import com.google.common.base.ParametricNullness;
import com.google.common.base.Preconditions;
import com.google.common.base.Receiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import org.jspecify.nullness.NullMarked;
import org.jspecify.nullness.Nullable;

@NullMarked
@GoogleInternal
@GwtCompatible
public final class Receivers {
    private static final Receiver<@Nullable Object> IGNORING_RECEIVER = new Receiver<Object>(){

        @Override
        public void accept(@CheckForNull Object object) {
        }

        public String toString() {
            return "Receivers.ignore()";
        }
    };

    private Receivers() {
    }

    public static <T> Receiver<T> ignore() {
        return IGNORING_RECEIVER;
    }

    public static <T> Receiver<T> collect(Collection<? super T> collection) {
        return new CollectingReceiver<T>(collection);
    }

    public static <T> Receiver<T> compose(Receiver<? super T> ... receivers) {
        return new CompositeReceiver<T>(Arrays.asList(receivers));
    }

    public static <T> Receiver<T> compose(Iterable<Receiver<T>> receivers) {
        return new CompositeReceiver<T>(receivers);
    }

    private static final class CollectingReceiver<T>
    implements Receiver<T> {
        private final Collection<? super T> collection;

        CollectingReceiver(Collection<? super T> collection) {
            this.collection = Preconditions.checkNotNull(collection);
        }

        @Override
        public void accept(@ParametricNullness T object) {
            this.collection.add(object);
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof CollectingReceiver) {
                CollectingReceiver that = (CollectingReceiver)obj;
                return this.collection == that.collection;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.collection);
        }
    }

    private static final class CompositeReceiver<T>
    implements Receiver<T> {
        private final List<Receiver<? super T>> receivers;

        CompositeReceiver(Iterable<? extends Receiver<? super T>> receivers) {
            this.receivers = CompositeReceiver.copy(receivers);
        }

        @Override
        public void accept(@ParametricNullness T object) {
            for (Receiver<T> receiver : this.receivers) {
                receiver.accept(object);
            }
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof CompositeReceiver) {
                CompositeReceiver that = (CompositeReceiver)obj;
                return this.receivers.equals(that.receivers);
            }
            return false;
        }

        public int hashCode() {
            return this.receivers.hashCode();
        }

        public String toString() {
            return "Receivers.compose(" + Joiner.on(", ").join(this.receivers) + ")";
        }

        private static <E> List<E> copy(Iterable<? extends E> elements) {
            ArrayList<E> list = new ArrayList<E>();
            for (E element : elements) {
                list.add(Preconditions.checkNotNull(element));
            }
            return list;
        }
    }
}

