/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtIncompatible;
import java.security.SecureRandom;
import java.util.Random;
import org.jspecify.nullness.NullMarked;

@NullMarked
@GoogleInternal
@GwtIncompatible
public final class Randoms {
    private static final Random random = new ReadOnlyRandom();
    private static final SecureRandom secureRandom = Randoms.newDefaultSecureRandom();
    private static final Random threadLocalSecureRandom = new ThreadLocalSecureRandom();
    private static final ThreadLocal<SecureRandom> localRandom = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return Randoms.newDefaultSecureRandom();
        }
    };

    private Randoms() {
    }

    public static SecureRandom secureRandom() {
        return secureRandom;
    }

    public static SecureRandom secureRandom(byte[] seed) {
        SecureRandom retval = new SecureRandom(seed);
        retval.nextLong();
        return retval;
    }

    public static Random threadLocalSecureRandom() {
        return threadLocalSecureRandom;
    }

    public static Random insecureRandom() {
        return random;
    }

    public static Random insecureRandom(long seed) {
        return new Random(seed);
    }

    private static SecureRandom newDefaultSecureRandom() {
        SecureRandom retval = new SecureRandom();
        retval.nextLong();
        return retval;
    }

    private static class ReadOnlyRandom
    extends Random {
        private static final long serialVersionUID = 898001275432099254L;
        private boolean initializationComplete = true;

        private ReadOnlyRandom() {
        }

        @Override
        public void setSeed(long seed) {
            if (this.initializationComplete) {
                throw new UnsupportedOperationException("Setting the seed on the shared Random object is not permitted");
            }
            super.setSeed(seed);
        }
    }

    private static final class ThreadLocalSecureRandom
    extends Random {
        private boolean initializationComplete = true;

        private ThreadLocalSecureRandom() {
        }

        SecureRandom current() {
            return (SecureRandom)localRandom.get();
        }

        @Override
        protected int next(int bits) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextBoolean() {
            return this.current().nextBoolean();
        }

        @Override
        public void nextBytes(byte[] bytes) {
            this.current().nextBytes(bytes);
        }

        @Override
        public double nextDouble() {
            return this.current().nextDouble();
        }

        @Override
        public float nextFloat() {
            return this.current().nextFloat();
        }

        @Override
        public double nextGaussian() {
            return this.current().nextGaussian();
        }

        @Override
        public int nextInt() {
            return this.current().nextInt();
        }

        @Override
        public int nextInt(int n) {
            return this.current().nextInt(n);
        }

        @Override
        public long nextLong() {
            return this.current().nextLong();
        }

        @Override
        public void setSeed(long seed) {
            if (this.initializationComplete) {
                throw new UnsupportedOperationException("Setting the seed on a thread-local Random object is not permitted");
            }
            super.setSeed(seed);
        }
    }
}

