// patchConsole.js
import { bufferLog } from './sendLogToServer';

(function patchConsole() {
    if (!import.meta.env.PROD) {
        console.log('patchConsole.js: Ambiente não é produção, patch não será aplicado.');
        return;
    }

   // console.log('patchConsole.js: Aplicando monkey patch em produção.');

    // Guardar referências originais
    const originalLog = console.log;
    const originalWarn = console.warn;
    const originalError = console.error;

    console.log = function (...args) {
        if(!args.length || args == '' || args == null || args == undefined) return;

        const callerInfo = getCallerInfo(); // <- extrai a origem
        // Envia para o servidor
        bufferLog('log', args, callerInfo);
        // Continua exibindo no console do navegador
       // originalLog.apply(console, [...args, '\n[Caller]', callerInfo]);
    };

    console.warn = function (...args) {

        if(!args.length || args == '' || args == null || args == undefined) return;

        const callerInfo = getCallerInfo();
        bufferLog('warn', args, callerInfo);
       // originalWarn.apply(console, [...args, '\n[Caller]', callerInfo]);
    };

    console.error = function (...args) {
        if(!args.length || args == '' || args == null || args == undefined) return;
        
        const callerInfo = getCallerInfo();
        bufferLog('error', args, callerInfo);
       // originalError.apply(console, [...args, '\n[Caller]', callerInfo]);
    };

    function getCallerInfo() {
        const err = new Error();
        if (!err.stack) return null;

        const stackLines = err.stack.split('\n');
        for (let i = 1; i < stackLines.length; i++) {
            const line = stackLines[i];
            if (
                !line.includes('patchConsole.js') &&
                !line.includes('getCallerInfo') &&
                !line.includes('console.') &&
                !line.includes('Error')
            ) {
                return line.trim();
            }
        }
        return null;
    }
})();