export enum PaymentModalityEnum {
  CashBillet = 1,
  TermBillet = 2,
  RecurrentCreditCard = 3,
  CreditCard = 4,
  Barter = 5,
  PicPay = 6,
  Pix = 7,
}

export const paymentModalityPipe = (status: PaymentModalityEnum): String => {
  switch (status) {
    case PaymentModalityEnum.CashBillet:
      "Boleto à vista"
      break;
    case PaymentModalityEnum.TermBillet:
      "Boleto à prazo"
      break;
    case PaymentModalityEnum.RecurrentCreditCard:
      "Cartão de Crédito Recorrente"
      break;
    case PaymentModalityEnum.CreditCard:
      "Cartão de Crédito"
      break;
    case PaymentModalityEnum.Barter:
      "Permuta"
      break;
    case PaymentModalityEnum.PicPay:
      "Picpay"
      break;
    case PaymentModalityEnum.Pix:
      "Pix"
      break;
    default:
      "-"
      break;
  }
}
