# vue

O frontend é desenvolvido em Vue 3 com Vite Server, Vuetify e o tema Vuexy. No servidor é utilizado a biblioteca PM2 para deixar o servidor dev com hot-reload rondando como uma instância.

## PM2

Para instalar o PM2 globalmente, execute o comando:

```sh
npm install pm2@latest -g
```

Para iniciar o servidor vite dev com PM2, execute o comando:

```sh
pm2 start npm --name "frontend" -- run dev
```

Veja a documentação do PM2 [PM2 Documentation](https://pm2.keymetrics.io/docs/usage/quick-start/).

## Modo de Desenvolvimento

Altere o arquivo `.env` para `VITE_API_BASE_URL=http://localhost:3000/api` para apontar para o backend e também `VITE_URL=http://localhost` para definir a URL base do frontend.

Altere também o `VITE_MODE` para `VITE_MODE=dev` para ativar o modo de desenvolvimento e `VITE_MODE=prod` para o modo de produção, isso definirá o servidor entre http e https.

## Configurações do Vite

Veja [Vite Configuration Reference](https://vitejs.dev/config/).

## Componentes do Vuetify

Veja [Vuetify Components](https://vuetifyjs.com/en/components/api-explorer).

## Documentação do tema Vuexy

Veja [Vuexy Documentation](https://pixinvent.com/demo/vuexy-vuejs-admin-dashboard-template/documentation/).

## Instação do Projeto

```sh
npm install --legacy-peer-deps
```

### Iniciar servidor de desenvolvimento com hot reload na porta :5173

```sh
npm run dev
```

### Compilar e minificar para produção

```sh
npm run build
```
