/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.util.Pack;

public abstract class XMSSAddress {
    private final int layerAddress;
    private final long treeAddress;
    private final int type;
    private final int keyAndMask;

    protected XMSSAddress(Builder builder) {
        this.layerAddress = builder.layerAddress;
        this.treeAddress = builder.treeAddress;
        this.type = builder.type;
        this.keyAndMask = builder.keyAndMask;
    }

    protected byte[] toByteArray() {
        byte[] byteRepresentation = new byte[32];
        Pack.intToBigEndian(this.layerAddress, byteRepresentation, 0);
        Pack.longToBigEndian(this.treeAddress, byteRepresentation, 4);
        Pack.intToBigEndian(this.type, byteRepresentation, 12);
        Pack.intToBigEndian(this.keyAndMask, byteRepresentation, 28);
        return byteRepresentation;
    }

    protected final int getLayerAddress() {
        return this.layerAddress;
    }

    protected final long getTreeAddress() {
        return this.treeAddress;
    }

    public final int getType() {
        return this.type;
    }

    public final int getKeyAndMask() {
        return this.keyAndMask;
    }

    protected static abstract class Builder<T extends Builder> {
        private final int type;
        private int layerAddress = 0;
        private long treeAddress = 0L;
        private int keyAndMask = 0;

        protected Builder(int type) {
            this.type = type;
        }

        protected T withLayerAddress(int val) {
            this.layerAddress = val;
            return this.getThis();
        }

        protected T withTreeAddress(long val) {
            this.treeAddress = val;
            return this.getThis();
        }

        protected T withKeyAndMask(int val) {
            this.keyAndMask = val;
            return this.getThis();
        }

        protected abstract XMSSAddress build();

        protected abstract T getThis();
    }
}

