/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mceliece;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public class McElieceParameters
implements CipherParameters {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int m;
    private int t;
    private int n;
    private int fieldPoly;
    private Digest digest;

    public McElieceParameters() {
        this(11, 50);
    }

    public McElieceParameters(Digest digest) {
        this(11, 50, digest);
    }

    public McElieceParameters(int keysize) {
        this(keysize, null);
    }

    public McElieceParameters(int keysize, Digest digest) {
        if (keysize < 1) {
            throw new IllegalArgumentException("key size must be positive");
        }
        this.m = 0;
        this.n = 1;
        while (this.n < keysize) {
            this.n <<= 1;
            ++this.m;
        }
        this.t = this.n >>> 1;
        this.t /= this.m;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(this.m);
        this.digest = digest;
    }

    public McElieceParameters(int m4, int t2) {
        this(m4, t2, null);
    }

    public McElieceParameters(int m4, int t2, Digest digest) {
        if (m4 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (m4 > 32) {
            throw new IllegalArgumentException("m is too large");
        }
        this.m = m4;
        this.n = 1 << m4;
        if (t2 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (t2 > this.n) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        this.t = t2;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(m4);
        this.digest = digest;
    }

    public McElieceParameters(int m4, int t2, int poly) {
        this(m4, t2, poly, null);
    }

    public McElieceParameters(int m4, int t2, int poly, Digest digest) {
        this.m = m4;
        if (m4 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (m4 > 32) {
            throw new IllegalArgumentException(" m is too large");
        }
        this.n = 1 << m4;
        this.t = t2;
        if (t2 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (t2 > this.n) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(poly) != m4 || !PolynomialRingGF2.isIrreducible(poly)) {
            throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
        }
        this.fieldPoly = poly;
        this.digest = digest;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }
}

