/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.crypto.gmss.GMSSUtils;
import org.bouncycastle.pqc.crypto.gmss.Treehash;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.encoders.Hex;

public class GMSSRootCalc {
    private int heightOfTree;
    private int mdLength;
    private Treehash[] treehash;
    private Vector[] retain;
    private byte[] root;
    private byte[][] AuthPath;
    private int K;
    private Vector tailStack;
    private Vector heightOfNodes;
    private Digest messDigestTree;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private boolean isInitialized;
    private boolean isFinished;
    private int indexForNextSeed;
    private int heightOfNextSeed;

    public GMSSRootCalc(int heightOfTree, int K2, GMSSDigestProvider digestProvider) {
        this.heightOfTree = heightOfTree;
        this.digestProvider = digestProvider;
        this.messDigestTree = digestProvider.get();
        this.mdLength = this.messDigestTree.getDigestSize();
        this.K = K2;
        this.index = new int[heightOfTree];
        this.AuthPath = new byte[heightOfTree][this.mdLength];
        this.root = new byte[this.mdLength];
        this.retain = new Vector[this.K - 1];
        for (int i = 0; i < K2 - 1; ++i) {
            this.retain[i] = new Vector();
        }
    }

    public void initialize(Vector sharedStack) {
        int i;
        this.treehash = new Treehash[this.heightOfTree - this.K];
        for (i = 0; i < this.heightOfTree - this.K; ++i) {
            this.treehash[i] = new Treehash(sharedStack, i, this.digestProvider.get());
        }
        this.index = new int[this.heightOfTree];
        this.AuthPath = new byte[this.heightOfTree][this.mdLength];
        this.root = new byte[this.mdLength];
        this.tailStack = new Vector();
        this.heightOfNodes = new Vector();
        this.isInitialized = true;
        this.isFinished = false;
        for (i = 0; i < this.heightOfTree; ++i) {
            this.index[i] = -1;
        }
        this.retain = new Vector[this.K - 1];
        for (i = 0; i < this.K - 1; ++i) {
            this.retain[i] = new Vector();
        }
        this.indexForNextSeed = 3;
        this.heightOfNextSeed = 0;
    }

    public void update(byte[] seed, byte[] leaf) {
        if (this.heightOfNextSeed < this.heightOfTree - this.K && this.indexForNextSeed - 2 == this.index[0]) {
            this.initializeTreehashSeed(seed, this.heightOfNextSeed);
            ++this.heightOfNextSeed;
            this.indexForNextSeed *= 2;
        }
        this.update(leaf);
    }

    public void update(byte[] leaf) {
        if (this.isFinished) {
            System.out.print("Too much updates for Tree!!");
            return;
        }
        if (!this.isInitialized) {
            System.err.println("GMSSRootCalc not initialized!");
            return;
        }
        this.index[0] = this.index[0] + 1;
        if (this.index[0] == 1) {
            System.arraycopy(leaf, 0, this.AuthPath[0], 0, this.mdLength);
        } else if (this.index[0] == 3 && this.heightOfTree > this.K) {
            this.treehash[0].setFirstNode(leaf);
        }
        if ((this.index[0] - 3) % 2 == 0 && this.index[0] >= 3 && this.heightOfTree == this.K) {
            this.retain[0].insertElementAt(leaf, 0);
        }
        if (this.index[0] == 0) {
            this.tailStack.addElement(leaf);
            this.heightOfNodes.addElement(Integers.valueOf(0));
        } else {
            byte[] help = new byte[this.mdLength];
            byte[] toBeHashed = new byte[this.mdLength << 1];
            System.arraycopy(leaf, 0, help, 0, this.mdLength);
            int helpHeight = 0;
            while (this.tailStack.size() > 0 && helpHeight == (Integer)this.heightOfNodes.lastElement()) {
                System.arraycopy(this.tailStack.lastElement(), 0, toBeHashed, 0, this.mdLength);
                this.tailStack.removeElementAt(this.tailStack.size() - 1);
                this.heightOfNodes.removeElementAt(this.heightOfNodes.size() - 1);
                System.arraycopy(help, 0, toBeHashed, this.mdLength, this.mdLength);
                this.messDigestTree.update(toBeHashed, 0, toBeHashed.length);
                help = new byte[this.messDigestTree.getDigestSize()];
                this.messDigestTree.doFinal(help, 0);
                if (++helpHeight >= this.heightOfTree) continue;
                int n = helpHeight;
                this.index[n] = this.index[n] + 1;
                if (this.index[helpHeight] == 1) {
                    System.arraycopy(help, 0, this.AuthPath[helpHeight], 0, this.mdLength);
                }
                if (helpHeight >= this.heightOfTree - this.K) {
                    if (helpHeight == 0) {
                        System.out.println("M\ufffd\ufffd\ufffdP");
                    }
                    if ((this.index[helpHeight] - 3) % 2 != 0 || this.index[helpHeight] < 3) continue;
                    this.retain[helpHeight - (this.heightOfTree - this.K)].insertElementAt(help, 0);
                    continue;
                }
                if (this.index[helpHeight] != 3) continue;
                this.treehash[helpHeight].setFirstNode(help);
            }
            this.tailStack.addElement(help);
            this.heightOfNodes.addElement(Integers.valueOf(helpHeight));
            if (helpHeight == this.heightOfTree) {
                this.isFinished = true;
                this.isInitialized = false;
                this.root = (byte[])this.tailStack.lastElement();
            }
        }
    }

    public void initializeTreehashSeed(byte[] seed, int index) {
        this.treehash[index].initializeSeed(seed);
    }

    public boolean wasInitialized() {
        return this.isInitialized;
    }

    public boolean wasFinished() {
        return this.isFinished;
    }

    public byte[][] getAuthPath() {
        return GMSSUtils.clone(this.AuthPath);
    }

    public Treehash[] getTreehash() {
        return GMSSUtils.clone(this.treehash);
    }

    public Vector[] getRetain() {
        return GMSSUtils.clone(this.retain);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    public Vector getStack() {
        Vector copy = new Vector();
        Enumeration en = this.tailStack.elements();
        while (en.hasMoreElements()) {
            copy.addElement(en.nextElement());
        }
        return copy;
    }

    public byte[][] getStatByte() {
        int i;
        int tailLength = this.tailStack == null ? 0 : this.tailStack.size();
        byte[][] statByte = new byte[1 + this.heightOfTree + tailLength][64];
        statByte[0] = this.root;
        for (i = 0; i < this.heightOfTree; ++i) {
            statByte[1 + i] = this.AuthPath[i];
        }
        for (i = 0; i < tailLength; ++i) {
            statByte[1 + this.heightOfTree + i] = (byte[])this.tailStack.elementAt(i);
        }
        return statByte;
    }

    public int[] getStatInt() {
        int i;
        int tailLength = this.tailStack == null ? 0 : this.tailStack.size();
        int[] statInt = new int[8 + this.heightOfTree + tailLength];
        statInt[0] = this.heightOfTree;
        statInt[1] = this.mdLength;
        statInt[2] = this.K;
        statInt[3] = this.indexForNextSeed;
        statInt[4] = this.heightOfNextSeed;
        statInt[5] = this.isFinished ? 1 : 0;
        statInt[6] = this.isInitialized ? 1 : 0;
        statInt[7] = tailLength;
        for (i = 0; i < this.heightOfTree; ++i) {
            statInt[8 + i] = this.index[i];
        }
        for (i = 0; i < tailLength; ++i) {
            statInt[8 + this.heightOfTree + i] = (Integer)this.heightOfNodes.elementAt(i);
        }
        return statInt;
    }

    public String toString() {
        int i;
        Object out = "";
        int tailLength = this.tailStack == null ? 0 : this.tailStack.size();
        for (i = 0; i < 8 + this.heightOfTree + tailLength; ++i) {
            out = (String)out + this.getStatInt()[i] + " ";
        }
        for (i = 0; i < 1 + this.heightOfTree + tailLength; ++i) {
            out = (String)out + new String(Hex.encode(this.getStatByte()[i])) + " ";
        }
        out = (String)out + "  " + this.digestProvider.get().getDigestSize();
        return out;
    }
}

