/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] H) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, H)) {
            return;
        }
        this.H = Arrays.clone(H);
        for (int i = 0; i < 16; ++i) {
            long[][] t2 = this.T[i];
            if (i == 0) {
                GCMUtil.asLongs(this.H, t2[1]);
                GCMUtil.multiplyP7(t2[1], t2[1]);
            } else {
                GCMUtil.multiplyP8(this.T[i - 1][1], t2[1]);
            }
            for (int n = 2; n < 256; n += 2) {
                GCMUtil.divideP(t2[n >> 1], t2[n]);
                GCMUtil.xor(t2[n], t2[1], t2[n + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        long[] t2 = this.T[15][x[15] & 0xFF];
        long z0 = t2[0];
        long z1 = t2[1];
        for (int i = 14; i >= 0; --i) {
            t2 = this.T[i][x[i] & 0xFF];
            z0 ^= t2[0];
            z1 ^= t2[1];
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }
}

